using System;
using Server.Items;
using System.Collections;

namespace Server.Mobiles
{
	//[CorpseName( "an inhuman corpse" )]
	public class IceOoze : DungeonRat
	{
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
//       public override bool BleedImmune { get { return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
		}

		[Constructable]
		public IceOoze() : base()
		{
			Hue = 0;//Regions.IceRegion.RandomIceHue;
			Name = "ledovy sliz";
			Body = 94;
			BaseSoundID = 456;
		}

		public override int GetAttackSound()
		{
			return -1;
		}
      
		public override bool OnBeforeDeath()
		{
			Server.Regions.KhaldunRegion.DropHealthOrb( this );
			
			return base.OnBeforeDeath();
		}
      
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Gems, Utility.RandomMinMax( 2, 5 ) );
		}

		public IceOoze( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
